/**
 * @~japanese
 * @file openEL_compoCnf.c
 * @brief		OpenEL コンポーネント管理テーブル
 * @Version 3.0.0
 *
 * @~english
 * @file openEL_compoCnf.h
 * @brief		OpenEL Conponent Management Table
 * @Version 3.0.0
 */
/*

Copyright (c) 2017,2018 Japan Embedded Systems Technology Association(JASA)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    Neither the name of the Association nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "openEL.h"
#include "openEL_0000000012345678.h"
#include "openEL_0000000080000001.h"

/** Component Table */
const struct elCompoTbl_st elCompoTbl[] = {
  //Vendor ID, Product ID, Function Table
	{0x00000000,0x00000001,(EL_CMN_FNC_TBL_T *)0}, // For Development
	{0x00000000,0x00000002,(EL_CMN_FNC_TBL_T *)0}, // For Development
	{0x00000000,0x00000003,(EL_CMN_FNC_TBL_T *)0}, // For Development
	{0x00000000,0x12345678,(EL_CMN_FNC_TBL_T *)(&component_0000000012345678)}, // Sample HAL Actuator Component
	{0x00000000,0x80000001,(EL_CMN_FNC_TBL_T *)(&component_0000000080000001)}, // Sample HAL Sensor Component
//	{0x00000001,0x00000001,(EL_CMN_FNC_TBL_T *)(&component_0000000100000001)}, // JASA, PF-WG-2016
//	{0x00000001,0x00000002,(EL_CMN_FNC_TBL_T *)(&component_0000000100000001)}, // JASA, PF-WG-2017
//	{0x00000001,0x00000003,(EL_CMN_FNC_TBL_T *)(&component_0000000100000001)}, // JASA, HW-WG
//	{0x00000002,0x00000001,(EL_CMN_FNC_TBL_T *)(&component_0000000200000001)}, // UTI, UTRX-17-1
//	{0x00000003,0x00000001,(EL_CMN_FNC_TBL_T *)(&component_0000000300000001)}, // ORIENTALMOTOR
//	{0x00000004,0x00000001,(EL_CMN_FNC_TBL_T *)(&component_0000000400000001)}, // DAIICHISEIKO
	{0xFFFFFFFF,0x00000001,(EL_CMN_FNC_TBL_T *)0},  // For Development
	{0xFFFFFFFF,0x00000002,(EL_CMN_FNC_TBL_T *)0},  // For Development
	{0xFFFFFFFF,0x00000003,(EL_CMN_FNC_TBL_T *)0},  // For Development
};

const uint32_t elSzCompoTbl = sizeof(elCompoTbl) / sizeof(struct elCompoTbl_st);
