/**
 * @~japanese
 * @file openEL_sensor.h
 * @brief		OpenEL センサー共有部
 * @Version 3.0.0
 *
 * @~english
 * @file openEL_sensor.h
 * @brief		OpenEL Sensor Common File
 * @Version 3.0.0
 */
/*

Copyright (c) 2017,2018 Japan Embedded Systems Technology Association(JASA)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    Neither the name of the Association nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#define OPENEL_SW_SURFACE_FRIEND (1)
#include "openEL.h"
#include <stdio.h>

enum ReturnCode HalTorqueSensorGetValue(HALCOMPONENT_T *halComponent, halfloat *list) {
	printf("HalTorqueSensorGetValue()\n");
	int32_t this;
	this = halComponent->halComponent_core.handle;
	printf("this=%x\n", this);
#if 1 == EL_SW_FAST
	uint32_t physicalPortID = elPortTbl[this].physicalPortID;
#else
	uint32_t physicalPortID;
	if ( 0 == (physicalPortID = elGetPhyicalPortID(this,ELSENSOR_PROPERTY)) ) {
		return HAL_ERROR;
	}
#endif
	return elPortTbl[this].fncTbl.pSensor->pFncGetValue(&halComponent, &list);
}

enum ReturnCode HalTorqueSensorGetTimedValue(HALCOMPONENT_T *halComponent, halfloat *list, int32_t *timer) {
	printf("HalTorqueSensorGetTimedValue()\n");
	int32_t this;
	this = halComponent->halComponent_core.handle;
	printf("this=%x\n", this);
#if 1 == EL_SW_FAST
  uint32_t physicalPortID = elPortTbl[this].physicalPortID;
#else
  uint32_t physicalPortID;
	if ( 0 == (physicalPortID = elGetPhyicalPortID(this,ELSENSOR_PROPERTY)) ) {
		return HAL_ERROR;
	}
#endif
	return elPortTbl[this].fncTbl.pSensor->pFncGetTimedValue(&halComponent, &list, &timer);
}

/*
ELInt32 elGetAnalog(ELUInt32 portID,ELUInt32 ch,ELUInt32 *pOutAnalogValue) {
#if 1 == EL_SW_FAST
	ELUint32 physicalPortID = elPortTbl[portID].physicalPortID;
#else
	ELUInt32 physicalPortID;
	if ( 0 == (physicalPortID = elGetPhyicalPortID(portID,ELSENSOR_PROPERTY)) ) {
		return EL_ERR_INIT;
	}
#endif
	return elPortTbl[portID].fncTbl.pSensor->pFncGetAnalog(physicalPortID,ch,pOutAnalogValue);
}
*/
