/**
 * @~japanese
 * @file sample.c
 * @brief		OpenEL サンプルファイル
 * @Version 3.0.0
 *
 * @~english
 * @file sample.c
 * @brief		OpenEL Sample File
 * @Version 3.0.0
 */
/*

Copyright (c) 2017, Japan Embedded Systems Technology Association(JASA)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    Neither the name of the Association nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "openEL.h"
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

void motor_notify_event(HALCOMPONENT_T *halComponent, int32_t event_id)
{
  printf("motor_notify_event\n");
//	printf("vendorId=%x productId=%x instanceId=%x event_id=%d\n", halId.vendorId, halId.productId, halId.instanceId, event_id);
}

void motor_notify_error(HALCOMPONENT_T *halComponent, int32_t error_id)
{
	printf("motor_notify_error\n");
//  printf("vendorId=%x productId=%x instanceId=%x error_id=%d\n", halId.vendorId, halId.productId, halId.instanceId, error_id);
}

void motor_notify_timer(EVENTTIMER_T *eventTimer)
{
	printf("motor_notify_timer\n");
}

int main()
{
  HALCOMPONENT_T motor_1;
//  HALCOMPONENT_T motor_2;
//  POSITIONCONTROLACTUATOR_T motor_1;
//  VELOCITYCONTROLACTUATOR_T motor_2;
//  TORQUECONTROLACTUATOR_T motor_3;
  HALCOMPONENT_T sensor_1;
//  TORQUESENSOR sensor_1;
	/* 初期設定 */
	motor_1.positionControlActuator.halId.deviceKindId=0x00000010;
	motor_1.positionControlActuator.halId.vendorId=0x00000000;
	motor_1.positionControlActuator.halId.productId=0x12345678;
	motor_1.positionControlActuator.halId.instanceId=0x00000001;

//  motor_1.halId.deviceKindId=0x00000010;
//	motor_1.halId.vendorId=0x00000000;
//	motor_1.halId.productId=0x12345678;
//	motor_1.halId.instanceId=0x00000001;

//  motor_2.halId.deviceKindId=0x00000010;
//	motor_2.halId.vendorId=0x00000000;
//	motor_2.halId.productId=0x12345678;
//	motor_2.halId.instanceId=0x00000002;

  sensor_1.torqueSensor.halId.deviceKindId=0x00000020;
	sensor_1.torqueSensor.halId.vendorId=0x00000000;
	sensor_1.torqueSensor.halId.productId=0x80000001;
	sensor_1.torqueSensor.halId.instanceId=0x00000001;

  HALOBSERVER_T motor_1_observer_1;
  motor_1_observer_1.notify_event = motor_notify_event;
  motor_1_observer_1.notify_error = motor_notify_error;
//  HalAddObserver(&motor_1.halComponent, &motor_1_observer_1);

  TIMEROBSERVER_T timerObserver_1;
  timerObserver_1.notify_timer = motor_notify_timer;

  EVENTTIMER_T eventTimer_1;
//  HalEventTimerAddObserver(&eventTimer_1, &timerObserver_1);
//  HalEventTimerSetEventPeriod(&eventTimer_1, 100);
//  HalEventTimerStartTimer(&eventTimer_1);

//  if(HAL_OK == HalInit((HALCOMPONENT*)&motor_1))
  if(HAL_OK == HalInit(&motor_1))
	  printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");
#if 0
  if(HAL_OK == HalInit(&motor_2))
	  printf("HAL_OK\n");
  else
    printf("HAL_ERROR\n");
#endif
  if(HAL_OK == HalInit(&sensor_1))
    printf("HAL_OK\n");
  else
    printf("HAL_ERROR\n");
#if 0
  if(HAL_OK == HalReInit(&motor_1))
    printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");
#endif
  float32_t position=123;
  float32_t value=0;
  int32_t timer_value=0;

  if(HAL_OK == HalSetPosition(&motor_1, position))
    printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");

  if(HAL_OK == HalGetPosition(&motor_1, &position))
    printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");

  printf("position=%f\n", position);
#if 0
  if(HAL_OK == HalFinalize(&motor_1))
    printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");
#endif
  if(HAL_OK == HalTorqueSensorGetValue(&sensor_1, &value))
    printf("HAL_OK\n");
  else
    printf("HAL_ERROR\n");
  printf("value=%f\n", value);

  if(HAL_OK == HalTorqueSensorGetTimedValue(&sensor_1, &value, &timer_value))
    printf("HAL_OK\n");
  else
    printf("HAL_ERROR\n");
  printf("value=%f, timer_value=%d\n", value, timer_value);

#if 0
  if(HAL_OK == HalFinalize(&motor_1.halComponent)) /* 2回コールした場合 */
    printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");
#endif
/*
  float32_t xyz[3]={10,20,30};
	if(HAL_OK == motor_1.SynchronizedSetPosition(xyz))
	  printf("HAL_OK\n");
	else
	  printf("HAL_ERROR\n");

	if(HAL_OK == motor_1.SynchronizedGetPosition(&xyz[0]))
	  printf("HAL_OK\n");
	else
	  printf("HAL_ERROR\n");

  printf("position_x = %f\n", xyz[0]);
  printf("position_y = %f\n", xyz[1]);
	printf("position_z = %f\n", xyz[2]);

	if(HAL_OK == motor_1.ReInit())
	  printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");

	if(HAL_OK == motor_1.Finalize())
	  printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");

	if(HAL_OK == sensor_1.Init())
	  printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");

	if(HAL_OK == sensor_1.Start())
	  printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");

  float32_t value[3];
	int32_t t;
	if(HAL_OK == sensor_1.GetTimedValue(&value[0], &t))
	  printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");
  printf("value[0]=%f, time=%d\n", value[0], t);

	if(HAL_OK == sensor_1.Stop())
	  printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");

	if(HAL_OK == sensor_1.Finalize())
	  printf("HAL_OK\n");
  else
	  printf("HAL_ERROR\n");
*/
  exit(EXIT_SUCCESS);
}
