/**
 * @~japanese
 * @file openEl_0000000012345678.c
 * @brief		OpenEL アクチュエーター ソースファイル
 * @Version 3.0.0
 *
 * @~english
 * @file openEl_0000000012345678.c
 * @brief		OpenEL Actuator Source File
 * @Version 3.0.0
 */
/*

Copyright (c) 2017,2018 Japan Embedded Systems Technology Association(JASA)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    Neither the name of the Association nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifdef __cplusplus
namespace el {
extern "C" {
#endif /* __cplusplus */
/*
#define OPENEL_SW_SURFACE_FRIEND 0
*/
#include "openEL.h"
#include "openEL_0000000012345678.h"
#include <stdio.h>

enum ReturnCode Init_0000000012345678(){
  printf("Init_0000000012345678\n");
  // インスタンスを覚えておく。HALComponentのアドレス（インスタンス）を箱に控えておく。
	return HAL_OK;
}

enum ReturnCode ReInit_0000000012345678(){
  printf("ReInit_0000000012345678\n");
	return HAL_OK;
}

enum ReturnCode Finalize_0000000012345678(){
  printf("Finalize_0000000012345678\n");
	return HAL_OK;
}

enum ReturnCode AddObserver_0000000012345678(HALOBSERVER_T halObserver){
  // インスタンスを覚えておく。HALComponentのアドレス（インスタンス）を箱に控えておく。
  return HAL_OK;
};

enum ReturnCode RemoveObserver_0000000012345678(HALOBSERVER_T halObserver){
  return HAL_OK;
};

enum ReturnCode GetProperty_0000000012345678(){
  return HAL_OK;
};

enum ReturnCode GetTime_0000000012345678(){
  return HAL_OK;
};

enum ReturnCode SetPosition_0000000012345678(HALCOMPONENT_T **halComponent, halfloat position){
  printf("SetPosition_0000000012345678, position=%f\n", position);
  (*halComponent)->positionControlActuator.actualPosition = position;
	return HAL_OK;
}

enum ReturnCode GetPosition_0000000012345678(HALCOMPONENT_T **halComponent, halfloat **position){
  printf("GetPosition_0000000012345678\n");
  *position = &(*halComponent)->positionControlActuator.actualPosition;
	return HAL_OK;
}

enum ReturnCode Dummy(){
  return HAL_OK;
};

/* Constant Table (Global scope) */
/*---------------------------------------------------------------------------*/
static const ELMOTOR_FNC_TBL_T motorFncTbl_0000000012345678 = {
        /* 0x00 */ Init_0000000012345678, /**< Initialize */
        /* 0x01 */ ReInit_0000000012345678, /**< ReInit */
        /* 0x02 */ Finalize_0000000012345678, /**< Finalize */
        /* 0x03 */ AddObserver_0000000012345678, /**< AddObserver */
        /* 0x04 */ RemoveObserver_0000000012345678, /**< RemoveObserver */
        /* 0x05 */ GetProperty_0000000012345678, /**< GetProperty */
        /* 0x06 */ GetTime_0000000012345678, /**< GetTime */
        /* 0x07 */ Dummy, /**< Reserved */

        /* 0x08 */ SetPosition_0000000012345678,
        /* 0x09 */ GetPosition_0000000012345678,
        /* 0x0A */ Dummy, /**< Reserved */
        /* 0x0B */ Dummy, /**< Reserved */
        /* 0x0C */ Dummy, /**< Reserved */
        /* 0x0D */ Dummy, /**< Reserved */
        /* 0x0E */ Dummy, /**< Reserved */
        /* 0x0F */ Dummy, /**< Reserved */

        /* 0x10 */ Dummy, /**< Reserved */
        /* 0x11 */ Dummy, /**< Reserved */
        /* 0x12 */ Dummy, /**< Reserved */
        /* 0x13 */ Dummy, /**< Reserved */
        /* 0x14 */ Dummy, /**< Reserved */
        /* 0x15 */ Dummy, /**< Reserved */
        /* 0x16 */ Dummy, /**< Reserved */
        /* 0x17 */ Dummy, /**< Reserved */

        /* 0x18 */ Dummy, /**< Reserved */
        /* 0x19 */ Dummy, /**< Reserved */
        /* 0x1A */ Dummy, /**< Reserved */
        /* 0x1B */ Dummy, /**< Reserved */
        /* 0x1C */ Dummy, /**< Reserved */
        /* 0x1D */ Dummy, /**< Reserved */
        /* 0x1E */ Dummy, /**< Reserved */
        /* 0x1F */ Dummy, /**< Reserved */
};

const EL_CMN_FNC_TBL_T component_0000000012345678 = {(void *)(&motorFncTbl_0000000012345678)};

#ifdef __cplusplus
} /* extern "C" */
} /* namespace el */
#endif /* __cplusplus */
