/**
 * @~japanese
 * @file openEL_NXT.h
 * @brief		OpenEL NXTヘッダーファイル
 * @Version 3.0.0
 *
 * @~english
 * @file openEL_NXT.h
 * @brief		OpenEL NXT Header File
 * @Version 3.0.0
 */
/*

Copyright (c) 2017,2018 Japan Embedded Systems Technology Association(JASA)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    Neither the name of the Association nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef OPENEL_NXT_H_
#define OPENEL_NXT_H_

#define EL_NXT_PORT_A 0
#define EL_NXT_PORT_B 1
#define EL_NXT_PORT_C 2
#define EL_NXT_PORT_S1 3
#define EL_NXT_PORT_S2 4
#define EL_NXT_PORT_S3 5
#define EL_NXT_PORT_S4 6
#define EL_NXT_PORT_BATTERY 7
#define EL_NXT_PORT_SPEAKER 8
#define EL_NXT_PORT_BLUETOOTH 9
#define EL_NXT_PORT_NO_USE 65535


#define EL_NXT_PHYSICAL_PORT_A  (EL_NXT_PHYSICAL_ID_MOTOR | 0x00)
#define EL_NXT_PHYSICAL_PORT_B  (EL_NXT_PHYSICAL_ID_MOTOR | 0x01)
#define EL_NXT_PHYSICAL_PORT_C  (EL_NXT_PHYSICAL_ID_MOTOR | 0x02)
#define EL_NXT_PHYSICAL_PORT_S1 (EL_NXT_PHYSICAL_ID_SENSOR | 0x00)
#define EL_NXT_PHYSICAL_PORT_S2 (EL_NXT_PHYSICAL_ID_SENSOR | 0x01)
#define EL_NXT_PHYSICAL_PORT_S3 (EL_NXT_PHYSICAL_ID_SENSOR | 0x02)
#define EL_NXT_PHYSICAL_PORT_S4 (EL_NXT_PHYSICAL_ID_SENSOR | 0x03)
#define EL_NXT_PHYSICAL_PORT_BATTERY (EL_NXT_PHYSICAL_ID_BATTERY | 0x00)
#define EL_NXT_PHYSICAL_PORT_SPEAKER (EL_NXT_PHYSICAL_ID_SPEAKER | 0x00)
#define EL_NXT_PHYSICAL_PORT_BLUETOOTH (EL_NXT_PHYSICAL_ID_BLUETOOTH | 0x00)

#define EL_BT_NO_INIT     4
#define EL_BT_INITIALIZED 5
#define EL_BT_CONNECTED   6
#define EL_BT_STREAM      7

/* struct/union definition */
struct elMotorLegoNxt {
	/* 0x00 */ ELInt32 (*pFncMotorInit)(ELUInt32 portid);
	/* 0x01 */ ELInt32 (*pFncGetCtlMode)(ELUInt32 portid, ELInt32 *pMode);
	/* 0x02 */ ELInt32 (*pFncSetCtlMode)(ELUInt32 portid, ELInt32 *pMode);
	/* 0x03 */ ELInt32 (*pFncGetAngle)(ELUInt32 portid, ELUInt32 sw, ELFloat64 *pAngle);
	/* 0x04 */ ELInt32 (*pFncSetAngle)(ELUInt32 portid, ELFloat64 angle, ELFloat64 speed);
	/* 0x05 */ ELInt32 (*pFncResetEncoder)(ELUInt32 portid);
	/* 0x06 */ ELInt32 (*pFncGetSpeed)(ELUInt32 portid, ELInt32 idx, ELFloat64 *pOutSpeed);
	/* 0x07 */ ELInt32 (*pFncSetSpeed)(ELUInt32 portid, ELFloat64 speed);
	/* 0x08 */ ELInt32 (*pFncGetBrake)(ELUInt32 portid, ELBool *pFlagBrake);
	/* 0x09 */ ELInt32 (*pFncSetBrake)(ELUInt32 portid, ELBool *pFlagBrake);
};
typedef struct elMotorLegoNxt EL_MOTOR_LEGO_NXT_T;

struct elSensorLegoNxt {
	/* 0x00 */ ELInt32 (*pFncSensorInit)(ELUInt32 portid);
	/* 0x01 */ ELInt32 (*pFncGyroGetValue)(ELUInt32 portid, ELUInt16 *pValue);
	/* 0x02 */ ELInt32 (*pFncGyroGetOffset)(ELUInt32 portid, ELUInt16 *pValue);
	/* 0x03 */ ELInt32 (*pFncGyroSetOffset)(ELUInt32 portid, ELUInt16 offset);
	/* 0x04 */ ELInt32 (*pFncLightGetValue)(ELUInt32 portid, ELUInt16  *pValue);
	/* 0x05 */ ELInt32 (*pFncLightGetLED)(ELUInt32 portid, ELBool *pStatus);
	/* 0x06 */ ELInt32 (*pFncLightSetLED)(ELUInt32 portid, ELBool light);
	/* 0x07 */ ELInt32 (*pFncTouchGetState)(ELUInt32 portid, ELBool *pStatus);
	/* 0x08 */ ELInt32 (*pFncSonarInitialize)(ELUInt32 portid);
	/* 0x09 */ ELInt32 (*pFncSonarTerminate)(ELUInt32 portid);
	/* 0x0A */ ELInt32 (*pFncSonarGetValue)(ELUInt32 portid, ELInt32 *pValue);
};
typedef struct elSensorLegoNxt EL_SENSOR_LEGO_NXT_T;

struct elBatteryLegoNxt {
	/* 0x00 */ ELInt32 (*pFncBatteryInit)(ELUInt32 portid);
	/* 0x01 */ ELInt32 (*pFncGetVoltage)(ELUInt32 portid, ELUInt16 *pVoltage);
};
typedef struct elBatteryLegoNxt EL_BATTERY_LEGO_NXT_T;

struct elSpeakerLegoNxt {
	/* 0x00 */ ELInt32 (*pFncSpeakerInit)(ELUInt32 portid);
	/* 0x01 */ ELInt32 (*pFncOutput)(ELUInt32 portid, ELUInt32 freq, ELUInt32 mx, ELUInt32 vol);
};
typedef struct elSpeakerLegoNxt EL_SPEAKER_LEGO_NXT_T;

struct elBluetoothLegoNxt {
	/* 0x00 */ ELInt32 (*pFncBluetoothInit)(ELUInt32 portid);
	/* 0x01 */ ELInt32 (*pFncInitializeMaster)(ELUInt32 portid, const ELUChar *addr, const ELChar *pPin);
	/* 0x02 */ ELInt32 (*pFncInitializeSlave)(ELUInt32 portid, const ELChar *pPin);
	/* 0x03 */ ELInt32 (*pFncTerminate)(ELUInt32 portid);
	/* 0x04 */ ELInt32 (*pFncSendData)(ELUInt32 portid, const ELUInt8 *buf, ELUInt32 offset, ELUInt32 len, ELUInt32 *outsize);
	/* 0x05 */ ELInt32 (*pFncReceiveData)(ELUInt32 portid, ELUInt8 *buf, ELUInt32 offset, ELUInt32 len, ELUInt32 *outsize);
	/* 0x06 */ ELInt32 (*pFncGetDeviceName)(ELUInt32 portid, ELChar *pName);
	/* 0x07 */ ELInt32 (*pFncSetDeviceName)(ELUInt32 portid, const ELChar *pName);
	/* 0x08 */ ELInt32 (*pFncGetStatus)(ELUInt32 portid, ELInt32 *pStatus);
	/* 0x09 */ ELInt32 (*pFncGetSignalStrength)(ELUInt32 portid, ELInt32 *pStrength);
};
typedef struct elBluetoothLegoNxt EL_BLUETOOTH_LEGO_NXT_T;



#endif /* OPENEL_NXT_H_ */
