/**
 * @~japanese
 * @file openEL_sensor.h
 * @brief		OpenEL センサー共有部
 * @Version 3.0.0
 *
 * @~english
 * @file openEL_sensor.h
 * @brief		OpenEL Sensor Common File
 * @Version 3.0.0
 */
/*

Copyright (c) 2017,2018 Japan Embedded Systems Technology Association(JASA)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    Neither the name of the Association nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef OPNEEL_SENSOR_H_
#define OPNEEL_SENSOR_H_

#define ELSENSOR_PROPERTY (0x0020)

/** Sensor component --- function table */
typedef struct elSensorFncTblSt {
  /* 0x00 */ enum ReturnCode (*pFncInit)(); /**< Initialize */
	/* 0x01 */ enum ReturnCode (*pFncReInit)(); /**< ReInit */
	/* 0x02 */ enum ReturnCode (*pFncFinalize)(); /**< Finalize */
	/* 0x03 */ enum ReturnCode (*pFncAddObserver)(); /**< AddObserver */
	/* 0x04 */ enum ReturnCode (*pFncRemoveObserver)(); /**< RemoveObserver */
	/* 0x05 */ enum ReturnCode (*pFncGetProperty)(); /**< GetProperty */
	/* 0x06 */ enum ReturnCode (*pFncGetTime)(); /**< GetTime */
	/* 0x07 */ enum ReturnCode (*pFncDummy07)(); /**< Reserved */

  /* 0x08 */ enum ReturnCode (*pFncDummy08)(); /**< Reserved */
	/* 0x09 */ enum ReturnCode (*pFncDummy09)(); /**< Reserved */
	/* 0x0A */ enum ReturnCode (*pFncDummy0A)(); /**< Reserved */
	/* 0x0B */ enum ReturnCode (*pFncDummy0B)(); /**< Reserved */
  /* 0x0C */ enum ReturnCode (*pFncDummy0C)(); /**< Reserved */
	/* 0x0D */ enum ReturnCode (*pFncDummy0D)(); /**< Reserved */
	/* 0x0E */ enum ReturnCode (*pFncDummy0E)(); /**< Reserved */
	/* 0x0F */ enum ReturnCode (*pFncDummy0F)(); /**< Reserved */

  /* 0x10 */ enum ReturnCode (*pFncGetValue)(HALCOMPONENT_T **halComponent, halfloat **list); /**< GetValue */
	/* 0x11 */ enum ReturnCode (*pFncGetTimedValue)(HALCOMPONENT_T **halComponent, halfloat **list, int32_t **timer); /**< GetTimedValue */
	/* 0x12 */ enum ReturnCode (*pFncSetUnit)(char units); /**< SetUnit */
	/* 0x13 */ enum ReturnCode (*pFncGetUnit)(char *units); /**< GetUnit */
  /* 0x14 */ enum ReturnCode (*pFncDummy14)(); /**< Reserved */
	/* 0x15 */ enum ReturnCode (*pFncDummy15)(); /**< Reserved */
	/* 0x16 */ enum ReturnCode (*pFncDummy16)(); /**< Reserved */
	/* 0x17 */ enum ReturnCode (*pFncDummy17)(); /**< Reserved */

	/* 0x18 */ enum ReturnCode (*pFncSetReset)(); /**< Reserved */
	/* 0x19 */ enum ReturnCode (*pFncStart)(); /**< Reserved */
	/* 0x1A */ enum ReturnCode (*pFncStop)(); /**< Reserved */
	/* 0x1B */ enum ReturnCode (*pFncDummy1B)(); /**< Reserved */
	/* 0x1C */ enum ReturnCode (*pFncDummy1C)(); /**< Reserved */
	/* 0x1D */ enum ReturnCode (*pFncDummy1D)(); /**< Reserved */
	/* 0x1E */ enum ReturnCode (*pFncDummy1E)(); /**< Reserved */
	/* 0x1F */ enum ReturnCode (*pFncDummy1F)(); /**< Reserved */
} EL_SENSOR_FNC_TBL_T;

#endif /* OPNEEL_SENSOR_H_ */
