/**
 * @~japanese
 * @file openEL_0000000080000001.c
 * @brief		OpenEL トルクセンサー(0000000080000001) ソースファイル
 * @Version 3.0.0
 *
 * @~english
 * @file openEL_0000000080000001.c
 * @brief		OpenEL Torque Sensor(0000000080000001) Source File
 * @Version 3.0.0
 */
/*

Copyright (c) 2017,2018 Japan Embedded Systems Technology Association(JASA)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    Neither the name of the Association nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifdef __cplusplus
namespace el {
extern "C" {
#endif /* __cplusplus */

//#define OPENEL_SW_SURFACE_FRIEND 0
#include "openEL.h"
#include "openEL_0000000080000001.h"
#include <stdio.h>
#include <time.h>

enum ReturnCode Init_0000000080000001(){
  printf("Init_0000000080000001\n");
	return HAL_OK;
}

enum ReturnCode ReInit_0000000080000001(){
  printf("ReInit_0000000080000001\n");
	return HAL_OK;
}

enum ReturnCode Finalize_0000000080000001(){
  printf("Finalize_0000000080000001\n");
	return HAL_OK;
}

enum ReturnCode AddObserver_0000000080000001(HALOBSERVER_T halObserver){
  printf("AddObserver_0000000080000001\n");
  return HAL_OK;
};

enum ReturnCode RemoveObserver_0000000080000001(HALOBSERVER_T halObserver){
  printf("RemoveObserver_0000000080000001\n");
  return HAL_OK;
};

enum ReturnCode GetProperty_0000000080000001(){
  printf("GetProperty_0000000080000001\n");
  return HAL_OK;
};

enum ReturnCode GetTime_0000000080000001(){
  printf("GetTime_0000000080000001\n");
  return HAL_OK;
};

halfloat value=0;

enum ReturnCode GetValue_0000000080000001(HALCOMPONENT_T **halComponent, halfloat **list){
  printf("GetValue_0000000080000001\n");
  value = 11.0;
  *list = &value;
  return HAL_OK;
}

enum ReturnCode GetTimedValue_0000000080000001(HALCOMPONENT_T **halComponent, halfloat **list, int32_t **timer){
  printf("GetTimedValue_0000000080000001\n");
  time_t t = time(&t);
  int32_t tt;
  printf("%ld\n", t);
  tt = (int32_t)t;
  *timer = &tt;
  value = 12.0;
  *list = &value;
  return HAL_OK;
}

enum ReturnCode SetUnit_0000000080000001(char units){
  printf("SetUnit_0000000080000001\n");
  return HAL_OK;
}

enum ReturnCode GetUnit_0000000080000001(char *units){
  printf("GetUnit_0000000080000001\n");
  return HAL_OK;
}

enum ReturnCode SetReset_0000000080000001(){
  printf("SetReset_0000000080000001\n");
	return HAL_OK;
}

enum ReturnCode Start_0000000080000001(){
  printf("Start_0000000080000001\n");
//  eventTimerid.Start();
	return HAL_OK;
}

enum ReturnCode Stop_0000000080000001(){
  printf("Stop_0000000080000001\n");
//  eventTimerid.Stop();
	return HAL_OK;
}

/* Constant Table (Global scope) */
/*---------------------------------------------------------------------------*/
static const EL_SENSOR_FNC_TBL_T sensorFncTbl_0000000080000001 = {
        /* 0x00 */ Init_0000000080000001, /**< Initialize */
        /* 0x01 */ ReInit_0000000080000001, /**< ReInit */
        /* 0x02 */ Finalize_0000000080000001, /**< Finalize */
        /* 0x03 */ AddObserver_0000000080000001, /**< AddObserver */
        /* 0x04 */ RemoveObserver_0000000080000001, /**< RemoveObserver */
        /* 0x05 */ GetProperty_0000000080000001, /**< GetProperty */
        /* 0x06 */ GetTime_0000000080000001, /**< GetTime */
        /* 0x07 */ Dummy, /**< Reserved */

        /* 0x08 */ Dummy, /**< Reserved */
        /* 0x09 */ Dummy, /**< Reserved */
        /* 0x0A */ Dummy, /**< Reserved */
        /* 0x0B */ Dummy, /**< Reserved */
        /* 0x0C */ Dummy, /**< Reserved */
        /* 0x0D */ Dummy, /**< Reserved */
        /* 0x0E */ Dummy, /**< Reserved */
        /* 0x0F */ Dummy, /**< Reserved */

        /* 0x10 */ GetValue_0000000080000001,
        /* 0x11 */ GetTimedValue_0000000080000001,
        /* 0x12 */ SetUnit_0000000080000001,
        /* 0x13 */ GetUnit_0000000080000001,
        /* 0x14 */ Dummy, /**< Reserved */
        /* 0x15 */ Dummy, /**< Reserved */
        /* 0x16 */ Dummy, /**< Reserved */
        /* 0x17 */ Dummy, /**< Reserved */

        /* 0x18 */ SetReset_0000000080000001,
        /* 0x19 */ Start_0000000080000001,
        /* 0x1A */ Stop_0000000080000001,
        /* 0x1B */ Dummy, /**< Reserved */
        /* 0x1C */ Dummy, /**< Reserved */
        /* 0x1D */ Dummy, /**< Reserved */
        /* 0x1E */ Dummy, /**< Reserved */
        /* 0x1F */ Dummy, /**< Reserved */
};

const EL_CMN_FNC_TBL_T component_0000000080000001 = {(void *)(&sensorFncTbl_0000000080000001)};

#ifdef __cplusplus
} /* extern "C" */
} /* namespace el */
#endif /* __cplusplus */
